#NoTrayIcon
#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_icon=P!x shot.ico
#AutoIt3Wrapper_Compression=4
#AutoIt3Wrapper_Res_Comment=Take and save your screenshot easily
#AutoIt3Wrapper_Res_Description=d3monCorp
#AutoIt3Wrapper_Res_Fileversion=1.0.2.5
#AutoIt3Wrapper_Res_Fileversion_AutoIncrement=y
#AutoIt3Wrapper_Res_LegalCopyright=d3mon Corporation. All rights Reserved.
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****
;
_ReduceMemory(-1)

#include <ScreenCapture.au3>
Opt('GuiOnEventMode',1)

Local $PIX, $f_cfg = @TempDir & '\PixShot.CFG'

#Region GUI
$GUI = GUICreate('P!x Shot <d3monCorp>', 160, 255, -1, -1, -1, BitOR(0x00040000, 0x00000080) )
GUISetOnEvent(-3, '_Exit')

GUICtrlCreateLabel('Screenshots directory', 5, 5)
GUICtrlCreateButton('Browse', 110, 2, 45, 17)
GUICtrlSetOnEvent(-1, '_PIXDIR')

$e_dir = GUICtrlCreateEdit('', 5, 22, 150, 17, 2048 +128)

GUICtrlCreateLabel('Picture ext. :', 5, 47)
$c_ext = GUICtrlCreateCombo('---', 75, 43, 50, 17, 0x3)
GUICtrlSetData(-1, 'BMP|GIF|JPG|PNG|TIF', '---')
GUICtrlSetState($c_ext, 128)

GUICtrlCreateLabel("", 0, 70, 160, 2, 0x1000)

$c_sc = GUICtrlCreateCheckbox('SHOW CURSOR', 5, 75)
$c_fs = GUICtrlCreateCheckbox('FLASH SCREEN', 5, 95)

GUICtrlCreateLabel("", 0, 117, 160, 2, 0x1000)

$r_fs = GUICtrlCreateRadio('FULL SCREEN', 5, 120)
$r_ti = GUICtrlCreateRadio('NO TASKBAR+ICONS', 5, 140)
$r_nt = GUICtrlCreateRadio('NO TASKBAR', 5, 160)
$r_ni = GUICtrlCreateRadio('NO ICONS', 5, 180)

GUICtrlCreateLabel("", 0, 202, 160, 2, 0x1000)

$c_rst = GUICtrlCreateCheckbox('RESET NUMBER', 5, 205)

$b_ok = GUICtrlCreateButton('OK', 10, 230, 140, 20)
GUICtrlSetOnEvent(-1, '_PIXEND')
#EndRegion
;

If $CmdLine[0] Then
	If StringInStr($CmdLine[1], '/config')  Then
		GUICtrlSetData($e_dir, FileReadLine($f_cfg, 1))
		GUICtrlSetData($c_ext, FileReadLine($f_cfg, 2))
		If FileReadLine($f_cfg, 3) = 'TRUE' Then GUICtrlSetState($c_sc, 1)
		If FileReadLine($f_cfg, 5) = 'TRUE' Then GUICtrlSetState($c_fs, 1)

		If FileReadLine($f_cfg, 4) = '1' Then GUICtrlSetState($r_fs, 1)
		If FileReadLine($f_cfg, 4) = '2' Then GUICtrlSetState($r_ti, 1)
		If FileReadLine($f_cfg, 4) = '3' Then GUICtrlSetState($r_nt, 1)
		If FileReadLine($f_cfg, 4) = '4' Then GUICtrlSetState($r_ni, 1)
		If FileReadLine($f_cfg, 4) = ""  Then GUICtrlSetState($r_fs, 1)

		GUISetState(@SW_SHOW, $GUI)
	ElseIf StringInStr($CmdLine[1], '/del') Then
		_Remove( )
	EndIf
Else
	$hMutex = DllCall('kernel32.dll', 'hwnd', 'OpenMutex', 'int', 0x1F0001, 'int', False, 'str', 'P!x Shot')
	If $hMutex[0] Then Exit
	DllCall('kernel32.dll', 'hwnd', 'CreateMutex', 'int', 0, 'int', False, 'str', 'P!x Shot')

	HotKeySet('{PRINTSCREEN}' , '_PixShot')
	HotKeySet('^{PRINTSCREEN}', '_PixShotRegion')
	HotKeySet('!{PRINTSCREEN}', '_PixShotWindow')

	If Not FileExists(@TempDir & '\PixShot.txt') Then
		FileWrite(@TempDir & '\PixShot.txt', '0')
		GUICtrlSetState($r_fs, 1)
		GUISetState(@SW_SHOW, $GUI)
	EndIf
EndIf


While Sleep(60000)
	_ReduceMemory(-1)
WEnd

#Region Config
Func _PIXDIR( )
	Local $p_dir = FileSelectFolder('Select folder where you want to save screenshots', '', 7)

	If Not @error Then
		GLOBAL $PIX = $p_dir
		GUICtrlSetData($e_dir, $p_dir)
		GUICtrlSetState($c_ext, 64)
		GUICtrlSetState($b_ok, 64)
	EndIf
EndFunc   ;==>_PIXDIR

Func _PIXEND( )
	If (GUICtrlRead($c_ext) = '---') Then
		MsgBox(48, 'Pix Shot - Error', 'Please select a picture extension !')
	Else
		FileDelete($f_cfg)
		FileWrite($f_cfg, $PIX)

		$r_co = GUICtrlRead($c_ext)
		If $r_co <> 'JPG' Then FileDelete(@TempDir & '\PixJPGQ.txt')

		If 	   ($r_co = 'BMP') Then
			FileWrite($f_cfg, @CRLF & '.BMP')
		ElseIf ($r_co = 'GIF') Then
			FileWrite($f_cfg, @CRLF & '.GIF')
		ElseIf ($r_co = 'PNG') Then
			FileWrite($f_cfg, @CRLF & '.PNG')
		ElseIf ($r_co = 'JPG') Then
			FileWrite($f_cfg, @CRLF & '.JPG')
			$JPGQ = InputBox('JPG Quality P!x shot', 'Select JPG quality [max : 100]', '75', '', 200, 75)
			FileDelete(@TempDir & '\PixJPGQ.txt')

			If $JPGQ >= 1 And $JPGQ < 101 Then
				FileWrite(@TempDir & '\PixJPGQ.txt', $JPGQ)
			Else
				FileWrite(@TempDir & '\PixJPGQ.txt', '100')
			EndIf
		ElseIf ($r_co = 'TIF') Then
			FileWrite($f_cfg, @CRLF & '.TIF')
		EndIf

		If (GUICtrlRead($c_sc) = 1) Then
			FileWrite($f_cfg, @CRLF & 'TRUE')
		Else
			FileWrite($f_cfg, @CRLF & 'FALSE')
		EndIf

		If (GUICtrlRead($r_fs) = 1) Then
			FileWrite($f_cfg, @CRLF & '1')
		ElseIf (GUICtrlRead($r_ti) = 1) Then
			FileWrite($f_cfg, @CRLF & '2')
		ElseIf (GUICtrlRead($r_nt) = 1) Then
			FileWrite($f_cfg, @CRLF & '3')
		ElseIf (GUICtrlRead($r_ni) = 1) Then
			FileWrite($f_cfg, @CRLF & '4')
		EndIf

		If (GUICtrlRead($c_fs) = 1) Then
			FileWrite($f_cfg, @CRLF & 'TRUE')
		Else
			FileWrite($f_cfg, @CRLF & 'FALSE')
		EndIf

		If (GUICtrlRead($c_rst) = 1) Then
			FileDelete(@TempDir & '\PixShot.txt')
			FileWrite(@TempDir & '\PixShot.txt', '0')
		EndIf

		GUISetState(@SW_HIDE, $GUI)
		MsgBox(64, 'Pix Shot', 'Configuration updated !')

		$hMutex = DllCall('kernel32.dll', 'hwnd', 'OpenMutex', 'int', 0x1F0001, 'int', False, 'str', 'P!x Shot')
		If $hMutex[0] Then Exit
		DllCall('kernel32.dll', 'hwnd', 'CreateMutex', 'int', 0, 'int', False, 'str', 'P!x Shot')
	EndIf
EndFunc   ;==>_PIXEND
#EndRegion Config
;

Func _Exit( )
	Exit
EndFunc

Func _PixShot( )
	Local $p_nb = FileRead(@TempDir & '\PixShot.txt')
	Local $p_ext = FileReadLine($f_cfg, 2)
	Local $s_cur = FileReadLine($f_cfg, 3)

	If 	   FileReadLine($f_cfg, 4) = 1 Then
		Local $PIC = _ScreenCapture_Capture('', -1, -1, -1, -1, $s_cur)
		If FileExists(@TempDir & '\PixJPGQ.txt') Then _ScreenCapture_SetJPGQuality(FileRead(@TempDir & '\PixJPGQ.txt') )
		_ScreenCapture_SaveImage(FileReadLine($f_cfg, 1) & '\Pix' & $p_nb +1 & $p_ext, $PIC)
	ElseIf FileReadLine($f_cfg, 4) = 2 Then
		WinSetState('[CLASS:Shell_TrayWnd]', '', @SW_HIDE)
		WinSetState('Program Manager', '', @SW_HIDE)
		Local $PIC = _ScreenCapture_Capture('', -1, -1, -1, -1, $s_cur)
		If FileExists(@TempDir & '\PixJPGQ.txt') Then _ScreenCapture_SetJPGQuality(FileRead(@TempDir & '\PixJPGQ.txt') )
		_ScreenCapture_SaveImage(FileReadLine($f_cfg, 1) & '\Pix' & $p_nb +1 & $p_ext, $PIC)
		WinSetState('[CLASS:Shell_TrayWnd]', '', @SW_SHOW)
		WinSetState('Program Manager', '', @SW_SHOW)
	ElseIf FileReadLine($f_cfg, 4) = 3 Then
		WinSetState('[CLASS:Shell_TrayWnd]', '', @SW_HIDE)
		Local $PIC = _ScreenCapture_Capture('', -1, -1, -1, -1, $s_cur)
		If FileExists(@TempDir & '\PixJPGQ.txt') Then _ScreenCapture_SetJPGQuality(FileRead(@TempDir & '\PixJPGQ.txt') )
		_ScreenCapture_SaveImage(FileReadLine($f_cfg, 1) & '\Pix' & $p_nb +1 & $p_ext, $PIC)
		WinSetState('[CLASS:Shell_TrayWnd]', '', @SW_SHOW)
	ElseIf FileReadLine($f_cfg, 4) = 4 Then
		WinSetState('Program Manager', '', @SW_HIDE)
		Local $PIC = _ScreenCapture_Capture('', -1, -1, -1, -1, $s_cur)
		If FileExists(@TempDir & '\PixJPGQ.txt') Then _ScreenCapture_SetJPGQuality(FileRead(@TempDir & '\PixJPGQ.txt') )
		_ScreenCapture_SaveImage(FileReadLine($f_cfg, 1) & '\Pix' & $p_nb +1 & $p_ext, $PIC)
		WinSetState('Program Manager', '', @SW_SHOW)
	EndIf

	FileDelete(@TempDir & '\PixShot.txt')
	FileWrite(@TempDir & '\PixShot.txt', $p_nb +1)

	If FileReadLine($f_cfg, 5) = 'TRUE' Then _PixFlash($p_nb +1, $p_ext)
EndFunc   ;==>_PixShot

Func _PixShotRegion( )
	$wgh = WinGetHandle('Program Manager')

	ToolTip('When you are ready to draw the region, press left-click', 50, 50)
	While Not _IsPressed(01)
		$mgp = MouseGetPos( )
		Sleep(100)
	WEnd
	ToolTip("")

	$GUI_2 = GUICreate("", 10, 10, $mgp[0], $mgp[1], 0x80000000 + 0x00800000, -1, $wgh)
	GUISetBkColor(0x3399FF, $GUI_2)
	WinSetTrans($GUI_2, "", 150)
	GUISetState(@SW_SHOW,$GUI_2)

	While _IsPressed(01)
		Sleep(100)
	WEnd

	While Not _IsPressed(01)
		$mgp_2 = MouseGetPos( )
		WinMove($GUI_2, "", $mgp[0], $mgp[1], $mgp_2[0] - $mgp[0], $mgp_2[1] - $mgp[1], 0)
		Sleep(100)
	WEnd
	GUIDelete($GUI_2)

	Local $p_nb = FileRead(@TempDir & '\PixShot.txt')
	Local $p_ext = FileReadLine($f_cfg, 2)

	Local $PIC = _ScreenCapture_Capture('', $mgp[0], $mgp[1], $mgp_2[0], $mgp_2[1], FileReadLine($f_cfg, 3) )
	If FileExists(@TempDir & '\PixJPGQ.txt') Then _ScreenCapture_SetJPGQuality(FileRead(@TempDir & '\PixJPGQ.txt') )
	_ScreenCapture_SaveImage(FileReadLine($f_cfg, 1) & '\Pix' & $p_nb +1 & $p_ext, $PIC)

	FileDelete(@TempDir & '\PixShot.txt')
	FileWrite(@TempDir & '\PixShot.txt', $p_nb +1)

	If FileReadLine($f_cfg, 5) = 'TRUE' Then _PixFlash($p_nb +1, $p_ext)
EndFunc

Func _PixShotWindow( )
	Local $p_nb = FileRead(@TempDir & '\PixShot.txt')
	Local $p_ext = FileReadLine($f_cfg, 2)

	Local $PIC = _ScreenCapture_CaptureWnd('', WinGetHandle('[active]'), 0, 0, -1, -1, FileReadLine($f_cfg, 3) )
	If FileExists(@TempDir & '\PixJPGQ.txt') Then _ScreenCapture_SetJPGQuality(FileRead(@TempDir & '\PixJPGQ.txt') )
	_ScreenCapture_SaveImage(FileReadLine($f_cfg, 1) & '\Pix' & $p_nb +1 & $p_ext, $PIC)

	FileDelete(@TempDir & '\PixShot.txt')
	FileWrite(@TempDir & '\PixShot.txt', $p_nb +1)

	If FileReadLine($f_cfg, 5) = 'TRUE' Then _PixFlash($p_nb +1, $p_ext)
EndFunc

Func _PixFlash($p_nb, $p_ext)
	Local $wgh = WinGetHandle('Program Manager')

	#Region GUI_3
	$GUI_3 = GUICreate("", @DesktopWidth, @DesktopHeight, 0, 0, 0x80000000, -1, $wgh)
	GUICtrlCreateLabel('P!x Shot', 0, (@DesktopHeight / 2) - (72 / 2), @DesktopWidth, 100, 1)
	GUICtrlSetFont(-1, 72)
	GUICtrlCreateLabel('Pix' & $p_NB & $p_ext, 0, @DesktopHeight - 100, @DesktopWidth, 50, 1)
	GUICtrlSetFont(-1, 36)
	WinSetTrans($GUI_3, "", 100)
	GUISetBkColor(0xFFFFFF, $GUI_3)
	GUISetState(@SW_SHOW, $GUI_3)
	#EndRegion

	For $i = 100 To 250 Step +50
		WinSetTrans($GUI_3, "", $i)
	Next
	Sleep(100)
	For $i = 250 To 000 Step -50
		WinSetTrans($GUI_3, "", $i)
	Next

	GUIDelete($GUI_3)
EndFunc

Func _Remove( )
	WinKill('[CLASS:ConsoleWindowClass]')
	$MsgBox = MsgBox(36, 'P!x Shot - Remove','Are you sure you want to remove P!x shot ?')

	If $MsgBox = 6 Then
		FileDelete(@TempDir & '\PixShot.txt')
		FileDelete(@TempDir & '\PixShot.CFG')
		FileDelete(@TempDir & '\PixJPGQ.txt')

		RegDelete('HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Uninstall\P!x Shot')
		RegDelete('HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Run', 'P!x Shot')
		FileDelete(@DesktopDir & '\P!x Shot - Config.lnk')
		FileDelete(@ProgramFilesDir & '\d3monCorp\P!x Shot\P!x Shot - Remove.bat')

		MsgBox(48, 'P!x Shot - Remove', 'P!x Shot has been removed on your computer !')
		Exit _SelfDelete( )
	EndIf
EndFunc

#Region Internal
; #FUNCTION# ====================================================================================================================
; Name...........: _IsPressed
; Author ........: ezzetabi and Jon
; ===============================================================================================================================
Func _IsPressed($sHexKey, $vDLL = 'user32.dll')
	Local $a_R = DllCall($vDLL, 'int', 'GetAsyncKeyState', 'int', '0x' & $sHexKey)
	If Not @error And BitAND($a_R[0], 0x8000) = 0x8000 Then Return 1
	Return 0
EndFunc   ;==>_IsPressed

; #FUNCTION# ====================================================================================================================
; Name...........: _ReduceMemory
; Author ........: w_Outer, Rajesh V R, Prog@ndy
; ===============================================================================================================================
Func _ReduceMemory($i_PID = -1)
    If $i_PID = -1 or ProcessExists($i_PID) = 0 Then
        Local $ai_GetCurrentProcess = DllCall('kernel32.dll', 'ptr', 'GetCurrentProcess')
        Local $ai_Return = DllCall("psapi.dll", 'int', 'EmptyWorkingSet', 'ptr', $ai_GetCurrentProcess[0])
        Return $ai_Return[0]
    EndIf

    Local $ai_Handle = DllCall("kernel32.dll", 'ptr', 'OpenProcess', 'int', 0x1f0fff, 'int', False, 'int', $i_PID)
    Local $ai_Return = DllCall("psapi.dll", 'int', 'EmptyWorkingSet', 'ptr', $ai_Handle[0])
    DllCall('kernel32.dll', 'int', 'CloseHandle', 'ptr', $ai_Handle[0])
    Return $ai_Return[0]
EndFunc

; #FUNCTION# ====================================================================================================================
; Name...........: _SelfDelete
; Author ........: Unkown
; ===============================================================================================================================
Func _SelfDelete($iDelay = 1)
    Local $sCmdFile
    FileDelete(@TempDir & '\scratch.bat')
    $sCmdFile = 'ping -n ' & $iDelay & '127.0.0.1 > nul' & @CRLF _
            & ':loop' & @CRLF _
			& 'del "' & @ScriptFullPath & '"' & @CRLF _
			& 'rmdir "' & @ProgramFilesDir & '\d3monCorp\P!x Shot' & '"' & @CRLF _
            & 'if exist "' & @ScriptFullPath & '" goto loop' & @CRLF _
            & 'del ' & @TempDir & '\scratch.bat'

    FileWrite(@TempDir & '\scratch.bat', $sCmdFile)
	Run(@TempDir & '\scratch.bat', "", @SW_HIDE)
EndFunc
#EndRegion
